% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countna.R
\name{countna}
\alias{countna}
\title{Count NA values per transcript and condition}
\usage{
countna(allexprsdfs, expdf, nbcpu = 1, showtime = FALSE, verbose = TRUE)
}
\arguments{
\item{allexprsdfs}{A list of data frames containing expression data. The
first element is assumed to be the main table. The second element is a
vector of transcript names that passed the filtering of
'averageandfilterexprs'.}

\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{nbcpu}{An integer specifying the number of CPU cores to use for
parallel computation on transcripts. The number of transcripts is equal to
the number of lines provided as input of 'averageandfilterexprs'.
Defaults to \code{1}.}

\item{showtime}{A logical value indicating if the duration of the function
processing should be indicated before ending. Defaults to
\code{FALSE}.}

\item{verbose}{A logical flag indicating whether to print progress messages.
Defaults to \code{TRUE}.}
}
\value{
A data frame where each row corresponds to a transcript, along with
 its associated gene, strand, and the count of NA values.
}
\description{
This function takes a list of expression data frames, a condition
information data frame, and counts the number of NA values for each
transcript based on strand and condition. NA represent missing scores that
were filtered out from the black list and mappability track. The function
operates in parallel on transcripts to speed up the process using multiple
CPU cores.
}
\examples{
exppath <-  system.file("extdata", "exptab.csv", package="tepr")
transpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expthres <- 0.1

## Calculating averageandfilterexprs to call countNA
expdf <- read.csv(exppath)
transdf <- read.delim(transpath, header = FALSE)
avfilttest <- averageandfilterexprs(expdf, transdf, expthres,
        showtime = FALSE, verbose = FALSE)

## Testing countna
res <- countna(avfilttest, expdf, nbcpu = 1, verbose = FALSE)


}
\seealso{
[averageandfilterexprs]
}
