% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tergm.getMCMCsample.R
\name{tergm_MCMC_sample}
\alias{tergm_MCMC_sample}
\alias{tergm_MCMC_slave}
\title{Collects a sample of networks and returns the statistics of each sample}
\usage{
tergm_MCMC_sample(
  nw,
  model,
  model.mon = NULL,
  proposal,
  control,
  theta,
  verbose = FALSE,
  ...,
  eta = ergm.eta(theta, model$etamap)
)

tergm_MCMC_slave(state, eta, control, verbose)
}
\arguments{
\item{nw}{a \code{\link{network}} object}

\item{model}{the model, as returned by \code{\link{ergm_model}}}

\item{model.mon}{the optional monitoring model, as returned by \code{\link{ergm_model}}}

\item{proposal}{the proposal, as returned by \code{\link{ergm_proposal}}}

\item{control}{the list of control parameters}

\item{theta}{the vector of curved parameters}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{eta}{the vector of natural parameters}
}
\value{
returns the MCMC sample as a list containing:
\itemize{
\item statsmatrix.gen: the matrix of sampled statistics for \code{model},
relative to the initial network
\item statsmatrix.mon: the matrix of sampled statistics for \code{model.mon},
relative to the initial network
\item newnetwork: \code{ergm_state} with the final network from the
sampling process
\item changed: a matrix of changes, where the first column is
the timestamp of the change, the second and third columns are the tail and head
(respectively) of the changed dyad, and the fourth column is the edge state to which
the dyad was changed; this is only returned if \code{control$changes} is \code{TRUE}
\item maxchanges: the \code{maxchanges} value from the control list
}
}
\description{
\code{tergm_MCMC_sample} is a low-level internal function not intended to
be called directly by end users. It collects a sample of networks and
returns the statistics of each sample, along with a toggle matrix of the
changes needed from the original network to each in the sample.

\code{tergm_MCMC_slave} is an even
lower-level function that actually calls the C code.
}
\details{
This function is normally called inside \code{\link{simulate.tergm}} functions
to prepare inputs for the C sampling code and return its results
}
\seealso{
\code{\link{simulate.tergm}}
}
\keyword{internal}
