% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_gee.R
\name{vars_gee}
\alias{vars_gee}
\title{Set Variables to Use in GEE Model}
\usage{
vars_gee(
  response = "AVAL",
  covariates = c(),
  id = "USUBJID",
  arm = "ARM",
  visit = "AVISIT"
)
}
\arguments{
\item{response}{(\code{character})\cr name of response variable.}

\item{covariates}{(\code{character})\cr vector of names of variables to use as covariates.}

\item{id}{(\code{character})\cr name of variable to use to identify unique IDs.}

\item{arm}{(\code{character})\cr name of arm variable.}

\item{visit}{(\code{character})\cr name of visit variable.}
}
\value{
A list of variables that can be used as the \code{vars} argument in \code{\link[=fit_gee]{fit_gee()}}.
}
\description{
Set Variables to Use in GEE Model
}
\examples{
vars_gee()

vars_gee(
  response = "CHG",
  covariates = c("SEX", "RACE"),
  id = "SUBJID",
  arm = "ARMCD",
  visit = "AVISITN"
)
}
