# `tern.rbmi`

<!-- start badges -->
[![Check 🛠](https://github.com/insightsengineering/tern.rbmi/actions/workflows/check.yaml/badge.svg)](https://insightsengineering.github.io/tern.rbmi/main/unit-test-report/)
[![Docs 📚](https://github.com/insightsengineering/tern.rbmi/actions/workflows/docs.yaml/badge.svg)](https://insightsengineering.github.io/tern.rbmi/)
[![Code Coverage 📔](https://raw.githubusercontent.com/insightsengineering/tern.rbmi/_xml_coverage_reports/data/main/badge.svg)](https://insightsengineering.github.io/tern.rbmi/main/coverage-report/)

![GitHub forks](https://img.shields.io/github/forks/insightsengineering/tern.rbmi?style=social)
![GitHub Repo stars](https://img.shields.io/github/stars/insightsengineering/tern.rbmi?style=social)

![GitHub commit activity](https://img.shields.io/github/commit-activity/m/insightsengineering/tern.rbmi)
![GitHub contributors](https://img.shields.io/github/contributors/insightsengineering/tern.rbmi)
![GitHub last commit](https://img.shields.io/github/last-commit/insightsengineering/tern.rbmi)
![GitHub pull requests](https://img.shields.io/github/issues-pr/insightsengineering/tern.rbmi)
![GitHub repo size](https://img.shields.io/github/repo-size/insightsengineering/tern.rbmi)
![GitHub language count](https://img.shields.io/github/languages/count/insightsengineering/tern.rbmi)
[![Project Status: Active – The project has reached a stable, usable state and is being actively developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![Current Version](https://img.shields.io/github/r-package/v/insightsengineering/tern.rbmi/main?color=purple\&label=package%20version)](https://github.com/insightsengineering/tern.rbmi/tree/main)
[![Open Issues](https://img.shields.io/github/issues-raw/insightsengineering/tern.rbmi?color=red\&label=open%20issues)](https://github.com/insightsengineering/tern.rbmi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc)
<!-- end badges -->

## Overview

`tern.rbmi` provides an interface for Reference Based Multiple Imputation (`rbmi`) within the `tern` framework.

## Background

For details of the `rbmi` package, please see [Reference Based Multiple Imputation (rbmi)](https://github.com/insightsengineering/rbmi). The basic usage of `rbmi` core functions is described
in the `quickstart` vignette:

```R
vignette(topic = "quickstart", package = "rbmi")
```

## Installation

`tern.rbmi` is available on CRAN and you can install the latest released version with:

``` r
install.packages("tern.rbmi")
```

or you can install the latest development version directly from GitHub by running the following:

```r
# install.packages("pak")
pak::pak("insightsengineering/tern.rbmi")
```

## Usage

To understand how to use this package, please refer to the [Introduction to `tern.rbmi`](https://insightsengineering.github.io/tern.rbmi/latest-tag/articles/tern-rbmi.html) article, which provides multiple examples of code implementation.

## Stargazers and Forkers

### Stargazers over time

[![Stargazers over time](https://starchart.cc/insightsengineering/tern.rbmi.svg)](https://starchart.cc/insightsengineering/tern.rbmi)

### Stargazers

[![Stargazers repo roster for @insightsengineering/tern.rbmi](https://reporoster.com/stars/insightsengineering/tern.rbmi)](https://github.com/insightsengineering/tern.rbmi/stargazers)

### Forkers

[![Forkers repo roster for @insightsengineering/tern.rbmi](https://reporoster.com/forks/insightsengineering/tern.rbmi)](https://github.com/insightsengineering/tern.rbmi/network/members)
