% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_factor.R
\name{fct_collapse_only}
\alias{fct_collapse_only}
\title{Collapsing of Factor Levels and Keeping Only Those New Group Levels}
\usage{
fct_collapse_only(.f, ..., .na_level = "<Missing>")
}
\arguments{
\item{.f}{(\code{factor} or \code{character})\cr original vector.}

\item{...}{(named \code{character} vectors)\cr levels in each vector provided will be collapsed into
the new level given by the respective name.}

\item{.na_level}{(\code{string})\cr which level to use for other levels, which should be missing in the
new factor. Note that this level must not be contained in the new levels specified in \code{...}.}
}
\value{
A modified \code{factor} with collapsed levels. Values and levels which are not included
in the given \code{character} vector input will be set to the missing level \code{.na_level}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This collapses levels and only keeps those new group levels, in the order provided.
The returned factor has levels in the order given, with the possible missing level last (this will
only be included if there are missing values).
}
\note{
Any existing \code{NA}s in the input vector will not be replaced by the missing level. If needed,
\code{\link[=explicit_na]{explicit_na()}} can be called separately on the result.
}
\examples{
fct_collapse_only(factor(c("a", "b", "c", "d")), TRT = "b", CTRL = c("c", "d"))

}
\seealso{
\code{\link[forcats:fct_collapse]{forcats::fct_collapse()}}, \code{\link[forcats:fct_relevel]{forcats::fct_relevel()}} which are used internally.
}
