% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{stat_mean_ci}
\alias{stat_mean_ci}
\title{Confidence interval for mean}
\usage{
stat_mean_ci(
  x,
  conf_level = 0.95,
  na.rm = TRUE,
  n_min = 2,
  gg_helper = TRUE,
  geom_mean = FALSE
)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{na.rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{n_min}{(\code{numeric(1)})\cr a minimum number of non-missing \code{x} to estimate the confidence interval for mean.}

\item{gg_helper}{(\code{flag})\cr whether output should be aligned for use with \code{ggplot}s.}

\item{geom_mean}{(\code{flag})\cr whether the geometric mean should be calculated.}
}
\value{
A named \code{vector} of values \code{mean_ci_lwr} and \code{mean_ci_upr}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Convenient function for calculating the mean confidence interval. It calculates the arithmetic as well as the
geometric mean. It can be used as a \code{ggplot} helper function for plotting.
}
\examples{
stat_mean_ci(sample(10), gg_helper = FALSE)

p <- ggplot2::ggplot(mtcars, ggplot2::aes(cyl, mpg)) +
  ggplot2::geom_point()

p + ggplot2::stat_summary(
  fun.data = stat_mean_ci,
  geom = "errorbar"
)

p + ggplot2::stat_summary(
  fun.data = stat_mean_ci,
  fun.args = list(conf_level = 0.5),
  geom = "errorbar"
)

p + ggplot2::stat_summary(
  fun.data = stat_mean_ci,
  fun.args = list(conf_level = 0.5, geom_mean = TRUE),
  geom = "errorbar"
)

}
