% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk.R
\name{chk-dates}
\alias{chk-dates}
\alias{chk_date_yyyymmdd}
\alias{chk_date_yyyymm}
\alias{chk_date_yyyy}
\title{Checks: dates}
\usage{
chk_date_yyyymmdd(x)

chk_date_yyyymm(x)

chk_date_yyyy(x)
}
\arguments{
\item{x}{A vector to check.}
}
\value{
A logical vector flagging records that have passed or failed the
check.
}
\description{
Check that a vector conforms to a given date format such as YYYYMMDD.
}
\examples{

date <- c(20210101, 20211301, 20210132, 202101, 2021)
chk_date_yyyymmdd(date)

date <- c(202101, 202112, 202113, 2021)
chk_date_yyyymm(date)

date <- c("0001", "1688", "1775", "1789", "1791", "1848")
chk_date_yyyy(date)

}
\seealso{
\link[=chk-helper]{Checks: data frame helpers}

\link[=date-expectations]{Expectations: dates}

Other vector checks: 
\code{\link{chk-dummy}},
\code{\link{chk-labels}},
\code{\link{chk-patterns}},
\code{\link{chk-text}},
\code{\link{chk-uniqueness}},
\code{\link{chk-values}}
}
\concept{vector checks}
