% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-setequal.R
\name{expect_setequal}
\alias{expect_setequal}
\alias{expect_mapequal}
\title{Expectation: do two vectors contain the same values?}
\usage{
expect_setequal(object, expected)

expect_mapequal(object, expected)
}
\arguments{
\item{object}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}

\item{expected}{Computation and value to compare it to.

Both arguments supports limited unquoting to make it easier to generate
readable failures within a function or for loop. See \link{quasi_label} for
more details.}
}
\description{
\itemize{
\item \code{expect_setequal(x, y)} tests that every element of \code{x} occurs in \code{y},
and that every element of \code{y} occurs in \code{x}.
\item \code{expect_mapequal(x, y)} tests that \code{x} and \code{y} have the same names, and
that \code{x[names(y)]} equals \code{x}.
}
}
\details{
Note that \code{expect_setequal()} ignores names, and you will be warned if both
\code{object} and \code{expected} have them.
}
\examples{
expect_setequal(letters, rev(letters))
show_failure(expect_setequal(letters[-1], rev(letters)))

x <- list(b = 2, a = 1)
expect_mapequal(x, list(a = 1, b = 2))
show_failure(expect_mapequal(x, list(a = 1)))
show_failure(expect_mapequal(x, list(a = 1, b = "x")))
show_failure(expect_mapequal(x, list(a = 1, b = 2, c = 3)))
}
