% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-that.R
\name{expect_that}
\alias{expect_that}
\title{Expect that a condition holds.}
\usage{
expect_that(object, condition, info = NULL, label = NULL)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}

\item{condition, }{a function that returns whether or not the condition
is met, and if not, an error message to display.}

\item{info}{Extra information to be included in the message. This argument
is soft-deprecated and should not be used in new code. Instead see
alternatives in \link{quasi_label}.}

\item{label}{Used to customise failure messages. For expert use only.}
}
\value{
the (internal) expectation result as an invisible list
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#superseded'><img src='figures/lifecycle-superseded.svg' alt='Superseded lifecycle'></a>}}{\strong{Superseded}}

An old style of testing that's no longer encouraged.
}
\section{3rd edition}{

\ifelse{html}{\figure{lifecycle-deprecated.svg}{options: alt='Deprecated lifecycle'}}{\strong{Deprecated}}

This style of testing is formally deprecated as of the 3rd edition.
Use a more specific \code{expect_} function instead.
}

\examples{
expect_that(5 * 2, equals(10))
expect_that(sqrt(2) ^ 2, equals(2))
\dontrun{
expect_that(sqrt(2) ^ 2, is_identical_to(2))
}
}
\seealso{
\code{\link[=fail]{fail()}} for an expectation that always fails.
}
\keyword{internal}
