% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test_coverage.R
\name{get_test_coverage}
\alias{get_test_coverage}
\title{Get Test Coverage of Package}
\usage{
get_test_coverage(from_tags = TRUE, from_desc = TRUE)
}
\arguments{
\item{from_tags}{Logical scalar. Checks the files if your test directory for
testthis tags. Specifically, if you have the comment \code{#* @testing myfunction}
in any of your test files, myfunction will be marked as tested.}

\item{from_desc}{Logical scalar. Checks the \code{desc} argument
\code{test_that(...)} of the tests in your test directory for functions
names. E.g. if you have a testfile that contains
\code{test_that("myfunction works", {...})}, myfunction will be marked as
tested.}
}
\value{
A \code{Test_coverage} object. This is a \code{data.frame} containing the
following columns:
\itemize{
\item fun: Name of the function
\item exp: Is function is exported?
\item s3: Is function an S3 method?
\item tested: Do unit tests exist for function?
\item ignore: Is function listed in \file{tests/testthat/_testignore}?
}
}
\description{
This extracts the test coverage of the target package (usually the package
you are working on). Bear in mind that testthis uses a checklist-approach for
this, and depends that you either put the function name in your
\code{test_that()} calls, or used test_this tags. If you want automatic
analysis of test coverage, you must look in other packages such as \code{covr}.
}
\examples{

\dontrun{
x <- get_test_coverage()
as.data.frame(x)
}

}
