% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcm.R
\name{create_tcm}
\alias{create_tcm}
\alias{create_tcm.itoken}
\alias{create_tcm.list}
\title{Term-co-occurence matrix construction}
\usage{
create_tcm(itoken_src, vectorizer, ...)

\method{create_tcm}{itoken}(itoken_src, vectorizer, ...)

\method{create_tcm}{list}(itoken_src, vectorizer, verbose = FALSE, ...)
}
\arguments{
\item{itoken_src}{\code{list} of iterators over tokens from \link{itoken}.
Each element is a list of tokens, that is, tokenized and normalized
strings.}

\item{vectorizer}{\code{function} vectorizer function. See
\link{vectorizers}.}

\item{...}{arguments to \link{foreach} function which is used to iterate over
\code{itoken_src}.}

\item{verbose}{\code{logical} print status messages}
}
\value{
\code{dgCMatrix} TCM matrix
}
\description{
This is a high-level function for constructing a
  term-co-occurrence matrix. If a parallel backend is registered, it will
  construct the TCM in multiple threads.
}
\details{
The user should keep in mind that he or she should split data and
  and provide a list of \link{itoken} iterators. Each element of
  \code{itoken_src} will be handled in a separate thread combined at the end
  of processing.
}
\examples{
\dontrun{
data("movie_review")

# single threadx

tokens <- movie_review$review \%>\% tolower \%>\% word_tokenizer
it <- itoken(tokens)
v <- create_vocabulary(jobs)
vectorizer <- vocab_vectorizer(v, grow_dtm = FALSE, skip_grams_window = 3L)
tcm <- create_tcm(itoken(tokens), vectorizer)

# parallel version

# set to number of cores on your machine
N_WORKERS <- 1
splits <- split_into(movie_review$review, N_WORKERS)
jobs <- lapply(splits, itoken, tolower, word_tokenizer)
v <- create_vocabulary(jobs)
vectorizer <- vocab_vectorizer(v, grow_dtm = FALSE, skip_grams_window = 3L)
jobs <- lapply(splits, itoken, tolower, word_tokenizer)
doParallel::registerDoParallel(N_WORKERS)
tcm <- create_tcm(jobs, vectorizer)
}
}
\seealso{
\link{itoken}
}

