% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_RWMD.R
\docType{data}
\name{RelaxedWordMoversDistance}
\alias{RelaxedWordMoversDistance}
\alias{RWMD}
\title{Creates model which can be used for calculation of "relaxed word movers distance".}
\format{\code{\link{R6Class}} object.}
\usage{
RelaxedWordMoversDistance

RWMD
}
\description{
Relaxed word movers distance tries to measure distance between documents by
calculating how hard is to transform words from first document into words from second document
and vice versa. For more detail see original article: \url{http://mkusner.github.io/publications/WMD.pdf}.
}
\section{Fields}{

\describe{
\item{\code{progressbar}}{\code{logical = TRUE} whether to display progressbar}
}}

\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
rwmd = RelaxedWordMoversDistance$new(wv, method = c("cosine", "euclidean"), normalize = TRUE, progressbar = interactive())
rwmd$dist2(x, y)
rwmd$pdist2(x, y)
}
}

\section{Methods}{

\describe{
  \item{\code{$new(wv, method = c("cosine", "euclidean"))}}{Constructor for RWMD model
        For description of arguments see \bold{Arguments} section}
  \item{\code{$dist2(x, y)}}{Computes distance between each row of sparse matrix
        \code{x} and each row of sparse matrix \code{y}}
  \item{\code{$pdist2(x, y)}}{Computes "parallel" distance between rows of
        sparse matrix \code{x} and corresponding rows of the sparse matrix \code{y}}
}
}

\section{Arguments}{

\describe{
 \item{rwmd}{\code{RWMD} object}
 \item{x}{\code{x} sparse document term matrix}
 \item{y}{\code{y = NULL} sparse document term matrix.
         If \code{y = NULL} (as by default), we will assume \code{y = x} }
 \item{wv}{word vectors. Numeric matrix which contains word embeddings. Rows - words,
           columns - corresponding vectors. Rows should have word names.}
 \item{method}{name of the distance for measuring similarity between two word vectors.
               In original paper authors use \code{"euclidean"},
               however we use \code{"cosine"} by default (better from our experience).
               This means \code{distance = 1 - cosine_angle_betwen_wv}}
}
}

\examples{
\dontrun{
data("movie_review")
tokens = movie_review$review \%>\%
  tolower \%>\%
  word_tokenizer
v = create_vocabulary(itoken(tokens)) \%>\%
  prune_vocabulary(term_count_min = 5, doc_proportion_max = 0.5)
it = itoken(tokens)
vectorizer = vocab_vectorizer(v)
dtm = create_dtm(it, vectorizer)
tcm = create_tcm(it, vectorizer, skip_grams_window = 5)
glove_model = GloVe$new(word_vectors_size = 50, vocabulary = v, x_max = 10)
wv = glove_model$fit_transform(tcm, n_iter = 10)
# get average of main and context vectors as proposed in GloVe paper
wv = wv + t(glove_model$components)
rwmd_model = RWMD$new(wv)
rwmd_dist = dist2(dtm[1:100, ], dtm[1:10, ], method = rwmd_model, norm = 'none')
head(rwmd_dist)
}
}
\keyword{datasets}
