% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectorizers.R
\name{vectorizers}
\alias{vectorizers}
\alias{vocab_vectorizer}
\alias{hash_vectorizer}
\title{Vocabulary and hash vectorizers}
\usage{
vocab_vectorizer(vocabulary)

hash_vectorizer(hash_size = 2^18, ngram = c(1L, 1L), signed_hash = FALSE)
}
\arguments{
\item{vocabulary}{\code{text2vec_vocabulary} object, see \link{create_vocabulary}.}

\item{hash_size}{\code{integer} The number of of hash-buckets for the feature
hashing trick. The number must be greater than 0, and preferably it will be
a power of 2.}

\item{ngram}{\code{integer} vector. The lower and upper boundary of the range
of n-values for different n-grams to be extracted. All values of \code{n}
such that ngram_min <= n <= ngram_max will be used.}

\item{signed_hash}{\code{logical},  indicating whether to use a signed
hash-function to reduce collisions when hashing.}
}
\value{
A vectorizer \code{object} (closure).
}
\description{
This function creates an object (closure) which defines on how to
transform list of tokens into vector space - i.e. how to map words to indices.
It supposed to be used only as argument to \link{create_dtm}, \link{create_tcm},
\link{create_vocabulary}.
}
\examples{
data("movie_review")
N = 100
vectorizer = hash_vectorizer(2 ^ 18, c(1L, 2L))
it = itoken(movie_review$review[1:N], preprocess_function = tolower,
             tokenizer = word_tokenizer, n_chunks = 10)
hash_dtm = create_dtm(it, vectorizer)

it = itoken(movie_review$review[1:N], preprocess_function = tolower,
             tokenizer = word_tokenizer, n_chunks = 10)
v = create_vocabulary(it, c(1L, 1L) )

vectorizer = vocab_vectorizer(v)

it = itoken(movie_review$review[1:N], preprocess_function = tolower,
             tokenizer = word_tokenizer, n_chunks = 10)

dtm = create_dtm(it, vectorizer)
}
\seealso{
\link{create_dtm} \link{create_tcm} \link{create_vocabulary}
}
