% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_tag.R
\name{replace_tag}
\alias{replace_tag}
\title{Replace Handle Tags}
\usage{
replace_tag(x, pattern = qdapRegex::grab("rm_tag"), replacement = "", ...)
}
\arguments{
\item{x}{The text variable.}

\item{pattern}{Character time regex string to be matched in the given 
character vector.}

\item{replacement}{A function to operate on the extracted matches or a 
character string which is a replacement for the matched pattern.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector with tags replaced.
}
\description{
Replaces Twitter style handle tags (e.g., '@trinker').
}
\examples{
x <- c("@hadley I like #rstats for #ggplot2 work.",
    "Difference between #magrittr and #pipeR, both implement pipeline operators for #rstats: 
        http://renkun.me/r/2014/07/26/difference-between-magrittr-and-pipeR.html @timelyportfolio",
    "Slides from great talk: @ramnath_vaidya: Interactive slides from Interactive Visualization 
        presentation #user2014. http://ramnathv.github.io/user2014-rcharts/#1"
)

replace_tag(x)
replace_tag(x, replacement = '<<TAG>>')
replace_tag(x, replacement = '$3')

## Replacement with a function
replace_tag(x, 
    replacement = function(x){
        gsub('@', ' <<TO>> ', x)
    }
)
}
