% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finders.R
\name{findPoints}
\alias{findPoints}
\title{Find points within a PointTier.}
\usage{
findPoints(tier, pattern = "*", from = -Inf, to = Inf, ...)
}
\arguments{
\item{tier}{A \code{PointTier} object.}

\item{pattern}{A regular expression for matching point labels.
Default is \code{'*'} so that the search finds all points within
\code{[from, to]}.}

\item{from}{A numeric, the earliest time from which to search for points.
Default is \code{-Inf} so that the search includes the start of \code{tier}.}

\item{to}{A numeric, the latest time to which to search for points.
Default is \code{Inf} so that the search includes the end of \code{tier}.}

\item{...}{optional arguments passed to \code{grep}.}
}
\value{
A \code{data.frame} whose rows correspond to the points found
  according to the search criteria, and whose columns are:
  \code{$Index}, \code{$Time}, \code{$Label}.
}
\description{
Find points according to various search criteria: e.g., that occur within a
time range, whose labels match a pattern.
}
\seealso{
\code{\link{PointTier-class}}, \code{\link{grep}}
}

