% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling_core.R
\name{posterior.lda_topic_model}
\alias{posterior.lda_topic_model}
\title{Draw from the posterior of an LDA topic model}
\usage{
\method{posterior}{lda_topic_model}(object, which = "theta",
  num_samples = 100, ...)
}
\arguments{
\item{object}{An object of class \code{lda_topic_model}}

\item{which}{A character of either 'theta' or 'phi', indicating from which
matrix to draw posterior samples}

\item{num_samples}{Integer number of samples to draw}

\item{...}{Other arguments to be passed to \code{\link[textmineR]{TmParallelApply}}.}
}
\value{
Returns a data frame where each row is a single sample from the posterior. 
Each column is the distribution over a single parameter. The variable \code{var}
is a facet for subsetting by document (for theta) or topic (for phi).
}
\description{
This function takes an object of class \code{lda_topic_model} and
draws samples from the posterior of either \code{phi} or \code{theta}. This is 
useful for quantifying uncertainty around parametrs of the final model.
}
\examples{
\dontrun{
a <- posterior(object = nih_sample_topic_model, which = "theta", num_samples = 20)

plot(density(a$t1[a$var == "8693991"]))

b <- posterior(object = nih_sample_topic_model, which = "phi", num_samples = 20)

plot(denisty(b$research[b$var == "t_5"]))
}
}
\references{
Heinrich, G. (2005) Parameter estimation for text analysis. Technical report. 
\href{http://www.arbylon.net/publications/text-est.pdf}{http://www.arbylon.net/publications/text-est.pdf}
}
