% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_bar.R
\name{textplot_bar}
\alias{textplot_bar}
\title{Barplot of a frequency table using lattice}
\usage{
textplot_bar(
  x,
  panel = "Effect",
  total = sum(x),
  top = 40,
  col.panel = "lightgrey",
  col.line = "lightblue",
  lwd = 3,
  cextext = 0.5,
  addpct = FALSE,
  cexpct = 0.75,
  textpos = 3,
  pctpos = 1,
  v = NULL,
  col.abline = "red",
  ...
)
}
\arguments{
\item{x}{a table to plot or a data.frame with the first column the label and the second column the frequency}

\item{panel}{character string what to put into the panel}

\item{total}{integer with the total. Defaults to sum(x). Is used to plot the table counts as a percentage. In which case this is divided by the total.}

\item{top}{integer indicating to plot only the first 'top' table elements. Defaults to 40.}

\item{col.panel}{color of the panel. Defaults to lightgrey.}

\item{col.line}{color of the line. Passed on to the col argument in \code{lattice::panel.lines}}

\item{lwd}{width of the line. Passed on to the lwd argument in \code{lattice::panel.lines}}

\item{cextext}{numeric with the cex of the text with the counts plotted. Passed on to \code{lattice::panel.text}.}

\item{addpct}{logical indicating to add the percent with \code{lattice::panel.text}}

\item{cexpct}{numeric with the cex of the text plotted when using addpct. Passed on to \code{lattice::panel.text}.}

\item{textpos}{passed on to the pos argument of panel.text to indicate where to put the text of the frequencies}

\item{pctpos}{passed on to the pos argument of panel.text to indicate where to put the text of the percentages}

\item{v}{passed on to \code{lattice::panel.abline} to draw a vertical line}

\item{col.abline}{passed on to \code{lattice::panel.abline} to draw a vertical line}

\item{...}{other arguments passed on to \code{lattice::dotplot}}
}
\value{
the result of a call to \code{lattice::dotplot}
}
\description{
Barplot of a frequency table using lattice
}
\examples{
data(brussels_listings, package = 'udpipe')
x <- table(brussels_listings$neighbourhood)
x <- sort(x)
textplot_bar(x,
 panel = "Locations", col.panel = "darkgrey", xlab = "Listings",
 cextext = 0.75, addpct = TRUE, cexpct = 0.5)


x <- sample(LETTERS, 1000, replace = TRUE)
textplot_bar(sort(table(x)), panel = "Frequencies", xlab = "Frequency",
   cextext = 0.75, main = "Freq stats")
textplot_bar(sort(table(x)), panel = "Frequencies", addpct = TRUE, top = 15)

## x can also be a data.frame where the first column
## is the label and the second column the frequency
x <- data.frame(l = LETTERS, amount = rnorm(26))
textplot_bar(x)
textplot_bar(x, v = 0)
}
