% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfidf.R
\name{step_tfidf}
\alias{step_tfidf}
\alias{tidy.step_tfidf}
\title{Term Frequency-Inverse Document Frequency of Tokens}
\usage{
step_tfidf(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  vocabulary = NULL,
  res = NULL,
  smooth_idf = TRUE,
  norm = "l1",
  sublinear_tf = FALSE,
  prefix = "tfidf",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("tfidf")
)
}
\arguments{
\item{recipe}{A \link[recipes:recipe]{recipes::recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be
used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{vocabulary}{A character vector of strings to be considered.}

\item{res}{The words that will be used to calculate the term frequency will
be stored here once this preprocessing step has be trained by
\code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{smooth_idf}{TRUE smooth IDF weights by adding one to document
frequencies, as if an extra document was seen containing every term in the
collection exactly once. This prevents division by zero.}

\item{norm}{A character, defines the type of normalization to apply to term
vectors. "l1" by default, i.e., scale by the number of words in the
document. Must be one of c("l1", "l2", "none").}

\item{sublinear_tf}{A logical, apply sublinear term-frequency scaling, i.e.,
replace the term frequency with 1 + log(TF). Defaults to FALSE.}

\item{prefix}{A character string that will be the prefix to the
resulting new variables. See notes below.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_tfidf()} creates a \emph{specification} of a recipe step that will convert a
\code{\link[=tokenlist]{token}} variable into multiple variables containing the term
frequency-inverse document frequency of tokens.
}
\details{
It is strongly advised to use \link{step_tokenfilter} before using \link{step_tfidf} to
limit the number of variables created; otherwise you may run into memory
issues. A good strategy is to start with a low token count and increase
depending on how much RAM you want to use.

Term frequency-inverse document frequency is the product of two statistics:
the term frequency (TF) and the inverse document frequency (IDF).

Term frequency measures how many times each token appears in each
observation.

Inverse document frequency is a measure of how informative a word is, e.g.,
how common or rare the word is across all the observations. If a word appears
in all the observations it might not give that much insight, but if it only
appears in some it might help differentiate between observations.

The IDF is defined as follows: idf = log(1 + (# documents in the corpus) / (#
documents where the term appears))

The new components will have names that begin with \code{prefix}, then
the name of the variable, followed by the tokens all separated by
\code{-}. The variable names are padded with zeros. For example if
\code{prefix = "hash"}, and if \code{num_terms < 10}, their names will be
\code{hash1} - \code{hash9}. If \code{num_terms = 101}, their names will be
\code{hash001} - \code{hash101}.
}
\section{Tidying}{
When you \code{\link[recipes:tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{token}, \code{weight}, and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{token}{character, name of token}
\item{weight}{numeric, the calculated IDF weight}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(recipes)
library(modeldata)
data(tate_text)

tate_rec <- recipe(~., data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  step_tfidf(medium)

tate_obj <- tate_rec \%>\%
  prep()

bake(tate_obj, tate_text)

tidy(tate_rec, number = 2)
tidy(tate_obj, number = 2)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn characters into \code{\link[=tokenlist]{tokens}}

Other Steps for Numeric Variables From Tokens: 
\code{\link{step_lda}()},
\code{\link{step_texthash}()},
\code{\link{step_tf}()},
\code{\link{step_word_embeddings}()}
}
\concept{Steps for Numeric Variables From Tokens}
