% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_table.R
\name{bind_table}
\alias{bind_table}
\title{Column Bind a Table's Values with Its Names}
\usage{
bind_table(x, id.name = "id", content.name = "content", ...)
}
\arguments{
\item{x}{A \code{\link[base]{table}}.}

\item{id.name}{The name to use for the column created from the \code{\link[base]{table}}
\code{\link[base]{names}}.}

\item{content.name}{The name to use for the column created from the \code{\link[base]{table}}
values.}

\item{\ldots}{ignored.}
}
\value{
Returns a \code{\link[data.table]{data.table}} with the \code{\link[base]{names}}
from the \code{\link[base]{table}} as an \code{id} column.
}
\description{
\code{\link[base]{cbind}} a \code{\link[base]{table}}'s values with its
\code{\link[base]{names}} to form \code{id} (from the names) and
\code{content} columns.
}
\examples{
x <- table(sample(LETTERS[1:6], 1000, TRUE))
bind_table(x)
}

