% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{combine}
\alias{combine}
\alias{combine.default}
\alias{combine.data.frame}
\title{Combine Elements}
\usage{
combine(x, ...)

\method{combine}{default}(x, fix.punctuation = TRUE, ...)

\method{combine}{data.frame}(x, text.var = TRUE, ...)
}
\arguments{
\item{x}{A \code{\link[base]{data.frame}} or character vector with runs.}

\item{fix.punctuation}{logical If \code{TRUE} spaces before/after punctuation
that should not be are a removed (regex used:
\code{"(\\s+(?=[,.?!;:\%-]))|((?<=[$-])\\s+)"}).}

\item{text.var}{The name of the text variable.}

\item{\ldots}{Ignored.}
}
\value{
Returns a vector (if given a list/vector) or an expanded
\code{\link[data.table]{data.table}} with elements pasted together.
}
\description{
Combine (\code{\link[base]{paste}}) elements (\code{\link[base]{vector}}s,
\code{\link[base]{list}}s, or \code{\link[base]{data.frame}}s) together
with \code{collapse = TRUE}.
}
\examples{
(x <- split_token(DATA[["state"]][1], FALSE))
combine(x)

(x2 <- split_token(DATA[["state"]], FALSE))
combine(x2)

(x3 <- split_sentence(DATA))

## without dropping the non-group variable column
combine(x3)

## Dropping the non-group variable column
combine(x3[, 1:5, with=FALSE])
}
