% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R, R/math.R, R/summarize.R
\name{Ops.tf}
\alias{Ops.tf}
\alias{==.tfd}
\alias{!=.tfd}
\alias{==.tfb}
\alias{!=.tfb}
\alias{Ops.tfd}
\alias{Ops.tfb}
\alias{Math.tfd}
\alias{Math.tfb}
\alias{Summary.tf}
\alias{cummax.tfd}
\alias{cummin.tfd}
\alias{cumsum.tfd}
\alias{cumprod.tfd}
\alias{cummax.tfb}
\alias{cummin.tfb}
\alias{cumsum.tfb}
\alias{cumprod.tfb}
\title{Math, Summary and Ops Methods for \code{tf}}
\usage{
\method{Ops}{tf}(e1, e2)

\method{==}{tfd}(e1, e2)

\method{!=}{tfd}(e1, e2)

\method{==}{tfb}(e1, e2)

\method{!=}{tfb}(e1, e2)

\method{Ops}{tfd}(e1, e2)

\method{Ops}{tfb}(e1, e2)

\method{Math}{tfd}(x, ...)

\method{Math}{tfb}(x, ...)

\method{Summary}{tf}(...)

\method{cummax}{tfd}(...)

\method{cummin}{tfd}(...)

\method{cumsum}{tfd}(...)

\method{cumprod}{tfd}(...)

\method{cummax}{tfb}(...)

\method{cummin}{tfb}(...)

\method{cumsum}{tfb}(...)

\method{cumprod}{tfb}(...)
}
\arguments{
\item{e1}{an \code{tf} or a numeric vector}

\item{e2}{an \code{tf} or a numeric vector}

\item{x}{an \code{tf}}

\item{...}{\code{tf}-objects (not used for \code{Math} group generic)}
}
\value{
a \code{tf}- or \code{logical} vector with the computed result
}
\description{
These methods and operators mostly work \code{arg}-value-wise on \code{tf} objects, see
\code{?groupGeneric} for implementation details.
}
\details{
See examples below. Equality checks of functional objects are even more iffy
than usual for computer math and not very reliable. Note that \code{max} and \code{min}
are not guaranteed to be maximal/minimal over the entire domain, only on the
evaluation grid used for computation. With the exception of addition and
multiplication, operations on \code{tfb}-objects first evaluate the data on their
\code{arg}, perform computations on these evaluations and then convert back to an
\code{tfb}- object, so a loss of precision should be expected -- especially so for
small spline bases and/or very wiggly data.
}
\examples{
set.seed(1859)
f <- tf_rgp(4)
2 * f == f + f
sum(f) == f[1] + f[2] + f[3] + f[4]
log(exp(f)) == f
plot(f, points = FALSE)
lines(range(f), col = 2, lty = 2)

f2 <- tf_rgp(5) |> exp() |> tfb(k = 25)
layout(t(1:3))
plot(f2, col = gray.colors(5))
plot(cummin(f2), col = gray.colors(5))
plot(cumsum(f2), col = gray.colors(5))

# ?tf_integrate for integrals, ?tf_fwise for scalar summaries of each function
}
\seealso{
\code{\link[=tf_fwise]{tf_fwise()}} for scalar summaries of each function in a \code{tf}-vector
}
\concept{tidyfun compute}
\concept{tidyfun compute functions}
