% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_reduce}
\alias{dataset_reduce}
\title{Reduces the input dataset to a single element.}
\usage{
dataset_reduce(dataset, initial_state, reduce_func)
}
\arguments{
\item{dataset}{A dataset}

\item{initial_state}{An element representing the initial state of the transformation.}

\item{reduce_func}{A function that maps \verb{(old_state, input_element)} to new_state.
It must take two arguments and return a new element.
The structure of new_state must match the structure of initial_state.}
}
\value{
A dataset element.
}
\description{
The transformation calls reduce_func successively on every element of the input dataset
until the dataset is exhausted, aggregating information in its internal state.
The initial_state argument is used for the initial state and the final state is returned as the result.
}
\seealso{
Other dataset methods: 
\code{\link{dataset_batch}()},
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_decode_delim}()},
\code{\link{dataset_filter}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map}()},
\code{\link{dataset_map_and_batch}()},
\code{\link{dataset_padded_batch}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_prefetch_to_device}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take}()},
\code{\link{dataset_take_while}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
