% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{tfd_finite_discrete}
\alias{tfd_finite_discrete}
\title{The finite discrete distribution.}
\usage{
tfd_finite_discrete(
  outcomes,
  logits = NULL,
  probs = NULL,
  rtol = NULL,
  atol = NULL,
  validate_args = FALSE,
  allow_nan_stats = TRUE,
  name = "FiniteDiscrete"
)
}
\arguments{
\item{outcomes}{A 1-D floating or integer \code{Tensor}, representing a list of
possible outcomes in strictly ascending order.}

\item{logits}{A floating N-D \code{Tensor}, \code{N >= 1}, representing the log
probabilities of a set of FiniteDiscrete distributions. The first \code{N - 1}
dimensions index into a batch of independent distributions and the
last dimension represents a vector of logits for each discrete value.
Only one of \code{logits} or \code{probs} should be passed in.}

\item{probs}{A floating  N-D \code{Tensor}, \code{N >= 1}, representing the probabilities
of a set of FiniteDiscrete distributions. The first \code{N - 1} dimensions
index into a batch of independent distributions and the last dimension
represents a vector of probabilities for each discrete value. Only one
of \code{logits} or \code{probs} should be passed in.}

\item{rtol}{\code{Tensor} with same \code{dtype} as \code{outcomes}. The relative tolerance for
floating number comparison. Only effective when \code{outcomes} is a floating
\code{Tensor}. Default is \code{10 * eps}.}

\item{atol}{\code{Tensor} with same \code{dtype} as \code{outcomes}. The absolute tolerance for
floating number comparison. Only effective when \code{outcomes} is a floating
\code{Tensor}. Default is \code{10 * eps}.}

\item{validate_args}{Logical, default FALSE. When TRUE distribution parameters are checked
for validity despite possibly degrading runtime performance. When FALSE invalid inputs may
silently render incorrect outputs. Default value: FALSE.}

\item{allow_nan_stats}{Logical, default TRUE. When TRUE, statistics (e.g., mean, mode, variance)
use the value NaN to indicate the result is undefined. When FALSE, an exception is raised if
one or more of the statistic's batch members are undefined.}

\item{name}{string prefixed to Ops created by this class.}
}
\value{
a distribution instance.
}
\description{
The FiniteDiscrete distribution is parameterized by either probabilities or
log-probabilities of a set of \code{K} possible outcomes, which is defined by
a strictly ascending list of \code{K} values.
}
\details{
Note: log_prob, prob, cdf, mode, and entropy are differentiable with respect
to \code{logits} or \code{probs} but not with respect to \code{outcomes}.

Mathematical Details

The probability mass function (pmf) is,

\verb{pmf(x; pi, qi) = prod_j pi_j**[x == qi_j]}
}
\seealso{
For usage examples see e.g. \code{\link[=tfd_sample]{tfd_sample()}}, \code{\link[=tfd_log_prob]{tfd_log_prob()}}, \code{\link[=tfd_mean]{tfd_mean()}}.
}
