% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi-functions.R
\name{vi_kl_forward}
\alias{vi_kl_forward}
\title{The forward Kullback-Leibler Csiszar-function in log-space}
\usage{
vi_kl_forward(logu, self_normalized = FALSE, name = NULL)
}
\arguments{
\item{logu}{\code{float}-like \code{Tensor} representing \code{log(u)} from above.}

\item{self_normalized}{\code{logical} indicating whether \verb{f'(u=1)=0}. When
\verb{f'(u=1)=0} the implied Csiszar f-Divergence remains non-negative even
when \verb{p, q} are unnormalized measures.}

\item{name}{name prefixed to Ops created by this function.}
}
\value{
kl_forward_of_u: \code{float}-like \code{Tensor} of the Csiszar-function evaluated at
\code{u = exp(logu)}.
}
\description{
A Csiszar-function is a member of \verb{F = \{ f:R_+ to R : f convex \}}.
}
\details{
When \code{self_normalized = TRUE}, the KL-reverse Csiszar-function is \verb{f(u) = u log(u) - (u - 1)}.
When \code{self_normalized = FALSE} the \code{(u - 1)} term is omitted.
Observe that as an f-Divergence, this Csiszar-function implies: \code{D_f[p, q] = KL[q, p]}

The KL is "forward" because in maximum likelihood we think of minimizing \code{q} as in \code{KL[p, q]}.

Warning: when self_normalized = True\verb{this function makes non-log-space calculations and may therefore be numerically unstable for}|logu| >> 0`.
}
\seealso{
Other vi-functions: 
\code{\link{vi_amari_alpha}()},
\code{\link{vi_arithmetic_geometric}()},
\code{\link{vi_chi_square}()},
\code{\link{vi_csiszar_vimco}()},
\code{\link{vi_dual_csiszar_function}()},
\code{\link{vi_fit_surrogate_posterior}()},
\code{\link{vi_jeffreys}()},
\code{\link{vi_jensen_shannon}()},
\code{\link{vi_kl_reverse}()},
\code{\link{vi_log1p_abs}()},
\code{\link{vi_modified_gan}()},
\code{\link{vi_monte_carlo_variational_loss}()},
\code{\link{vi_pearson}()},
\code{\link{vi_squared_hellinger}()},
\code{\link{vi_symmetrized_csiszar_function}()}
}
\concept{vi-functions}
