% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{tgs_graph}
\alias{tgs_graph}
\title{Builds directed graph of correlations}
\usage{
tgs_graph(x, knn, k_expand, k_beta = 3)
}
\arguments{
\item{x}{see below}

\item{knn}{maximal node degree}

\item{k_expand}{see below}

\item{k_beta}{see below}
}
\value{
The graph edges are returned in a data frame, with the weight of
each edge. edge(i,j) receives weight 1 if its sym_rank is the lowest among
all edges of type edge(i,node). Formally defined: weight(i,j) = 1 -
(place(i,j) - 1) / knn, where place(i,j) is the location of edge(i,j) within
the sorted set of edges outgoing from i, i.e. edge(i,node). The sort is done
by sym_rank of the edges.
}
\description{
Builds directed graph of correlations where the nodes are the matrix
columns.
}
\details{
This function builds a directed graph based on the edges in 'x' and their
ranks.

'x' is a data frame containing 4 columns named: 'col1', 'col2', 'val',
'rank'. The third column ('val' can have a different name). The result in
the compatible format is returned, for example, by 'tgs_knn' function.

'tgs_graph' prunes some of the edges in 'x' based on the following steps:
\enumerate{
\item A pair of columns i, j that appears in 'x' in 'col1', 'col2' implies the
edge in the graph from i to j: edge(i,j). Let the rank of i and j be
rank(i,j).
\item Calculate symmetrised rank of i and j: sym_rank(i,j) = rank(i,j) *
rank(j,i). If one of the ranks is missing from the previous result sym_rank
is set to NA.
\item Prune the edges: remove edge(i,j) if sym_rank(i,j) == NA OR sym_rank(i,j)
< knn * knn * k_expand
\item Prune excessive incoming edges: remove edge(i,j) if more than knn *
k_beta edges of type edge(node,j) exist and sym_rank(i,j) is higher than
sym_rank(node,j) for node != j.
\item Prune excessive outgoing edges: remove edge(i,j) if more than knn edges
of type edge(i,node) exist and sym_rank(i,j) is higher than sym_rank(i,node)
for node != i.
}
}
\examples{
\donttest{
# Note: all the available CPU cores might be used

set.seed(seed = 1)
rows <- 100
cols <- 1000
vals <- sample(1:(rows * cols / 2), rows * cols, replace = TRUE)
m <- matrix(vals, nrow = rows, ncol = cols)
m[sample(1:(rows * cols), rows * cols / 1000)] <- NA

r1 <- tgs_cor(m, pairwise.complete.obs = FALSE, spearman = TRUE)
r2 <- tgs_knn(r1, knn = 30, diag = FALSE)
r3 <- tgs_graph(r2, knn = 3, k_expand = 10)
}

\dontshow{
options(tgs_use.blas = FALSE)
options(tgs_max.processes = 1)

set.seed(seed = 1)
rows <- 100
cols <- 100
vals <- sample(1:(rows * cols / 2), rows * cols, replace = TRUE)
m <- matrix(vals, nrow = rows, ncol = cols)
m[sample(1:(rows * cols), rows * cols / 1000)] <- NA

r1 <- tgs_cor(m, pairwise.complete.obs = FALSE, spearman = TRUE)
r2 <- tgs_knn(r1, knn = 30, diag = FALSE)
r3 <- tgs_graph(r2, knn = 3, k_expand = 10)
}

}
\keyword{~graph}
