% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modelling.R
\name{lspoints}
\alias{lspoints}
\title{Lowering Stress by excluding points (lspoints)}
\usage{
lspoints(data, method = "as", single = TRUE, comments = FALSE,
  type = "ordinal", weight = TRUE)
}
\arguments{
\item{data}{Dataset; the first column must be the ID of the unit of 
comparison, the other columns must be categories; see dataset requirements 
\code{simi}.}

\item{method}{Specifies the similarity index used to compute the similarity 
matrix, choose between "\code{as}" (Association Strength Index), 
"\code{jaccard}" (Jaccard  Index), "\code{cosine}" (Cosine Index), 
and "\code{inclusion}" (Inclusion Index). Default is \code{as}.}

\item{single}{If \code{TRUE}, single mentionings (i.e. one respondent 
mentioning just one category) are included when calculating the similarity 
matrix.}

\item{comments}{If \code{TRUE}, comments relating to exclusion or possible 
exclusion of categories and respondents are displayed. Default is 
\code{FALSE}.}

\item{type}{Specifies the type of MDS model used (for more details see
the package '\code{smacof}' by Mair, De Leeuw, Borg, & Groenen). Default is
\code{ordinal}.}

\item{weight}{If \code{TRUE}, the MDS model is calcualted using weights, 
i.e., similarities of zero are excluded. Default is \code{TRUE}.}
}
\value{
Matrix showing the categories excluded and the Stress values of the 
respective MDS models.
}
\description{
\code{lspoints} calculates Stress values for all combinations with n - 1 
categories.
}
\details{
This function is applicable to co-occurrence data. It shows the resulting 
 Stress values when single categories are excluded. The output consists in a 
 table showing which categories have been excluded and the resulting Stress 
 values. The table is sorted such that the the lowest Stress level occurs 
 at the top. The MDS model is computed using the package '\code{smacof}' 
 (Mair, De Leeuw, Borg, & Groenen). The first column of the input matrix 
 \code{data} should contain the ID of the unit of comparison, and the 
 following columns the categories for which the similarity matrices and MDS 
 maps are calculated (see also the description of \code{simi}). Note that 
 the purpose of this function is to assist modeling by helping to identify 
 potential problems. It is not, however, meant to be used for excluding 
 categories based solely on measures of fit and without substantial 
 justification.
}
\examples{
## Calculate Stress values for all combinations with n - 1 (i.e., 16) SDGs
data(SDG_coocurrence)
SDG_coocurrence <- SDG_coocurrence[,-2] # Drop second column
stress <- lspoints(SDG_coocurrence)
stress
}
\seealso{
\code{\link[smacof]{smacofSym}} for details on calculating MDS 
representations, \code{\link[thectar]{simi}} for details on calculating 
similarity matrices.
}
