% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescalers.R
\name{sigmoid_scaler}
\alias{sigmoid_scaler}
\title{Rescales a numeric vector using a Sigmoidal transformation}
\usage{
sigmoid_scaler(x, unitInt = TRUE)
}
\arguments{
\item{x}{\code{numeric vector}}

\item{unitInt}{\code{Boolean} whether to rescale into unit interval \code{[0,1]}. Defaults to \code{TRUE}}
}
\value{
\code{numeric vector}
}
\description{
\eqn{z_{i} = \left[1 + \exp(-\frac{x_{i} - \mu}{\sigma})\right]^{-1}}
}
\author{
Trent Henderson
}
