% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_features.R
\name{calculate_features}
\alias{calculate_features}
\title{Compute features on an input time series dataset}
\usage{
calculate_features(
  data,
  id_var = "id",
  time_var = "timepoint",
  values_var = "values",
  group_var = NULL,
  feature_set = c("catch22", "feasts", "tsfeatures", "Kats", "tsfresh", "TSFEL"),
  catch24 = FALSE,
  tsfresh_cleanup = FALSE,
  seed = 123
)
}
\arguments{
\item{data}{\code{data.frame} with at least 4 columns: id variable, group variable, time variable, value variable}

\item{id_var}{\code{character} specifying the ID variable to identify each time series. Defaults to \code{"id"}}

\item{time_var}{\code{character} specifying the time index variable. Defaults to \code{"timepoint"}}

\item{values_var}{\code{character} specifying the values variable. Defaults to \code{"values"}}

\item{group_var}{\code{character} specifying the grouping variable that each unique series sits under (if one exists). Defaults to \code{NULL}}

\item{feature_set}{\code{character} or \code{vector} of \code{character} denoting the set of time-series features to calculate. Defaults to \code{"catch22"}}

\item{catch24}{\code{Boolean} specifying whether to compute \code{catch24} in addition to \code{catch22} if \code{catch22} is one of the feature sets selected. Defaults to \code{FALSE}}

\item{tsfresh_cleanup}{\code{Boolean} specifying whether to use the in-built \code{tsfresh} relevant feature filter or not. Defaults to \code{FALSE}}

\item{seed}{\code{integer} denoting a fixed number for R's random number generator to ensure reproducibility. Defaults to \code{123}}
}
\value{
object of class \code{feature_calculations} that contains the summary statistics for each feature
}
\description{
Compute features on an input time series dataset
}
\examples{
featMat <- calculate_features(data = simData, 
  id_var = "id", 
  time_var = "timepoint", 
  values_var = "values", 
  group_var = "process", 
  feature_set = "catch22",
  seed = 123)

}
\author{
Trent Henderson
}
