% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{normalise}
\alias{normalise}
\alias{normalize}
\title{Scale each feature vector into a user-specified range for visualisation and modelling}
\usage{
normalise(
  data,
  norm_method = c("zScore", "Sigmoid", "RobustSigmoid", "MinMax", "MaxAbs"),
  unit_int = FALSE
)

normalize(
  data,
  norm_method = c("zScore", "Sigmoid", "RobustSigmoid", "MinMax", "MaxAbs"),
  unit_int = FALSE
)
}
\arguments{
\item{data}{either a \code{feature_calculations} object containing the raw feature matrix produced by \code{calculate_features} or a \code{vector} of class \code{numeric} containing values to be rescaled}

\item{norm_method}{\code{character} denoting the rescaling/normalising method to apply. Can be one of \code{"zScore"}, \code{"Sigmoid"}, \code{"RobustSigmoid"}, \code{"MinMax"}, or \code{"MaxAbs"}. Defaults to \code{"zScore"}}

\item{unit_int}{\code{Boolean} whether to rescale into unit interval \code{[0,1]} after applying normalisation method. Defaults to \code{FALSE}}
}
\value{
either an object of class \code{data.frame} or a \code{numeric} vector
}
\description{
`normalise()` and `normalize()` are synonyms.
}
\author{
Trent Henderson
}
