% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computation.R
\name{normalization}
\alias{normalization}
\title{Normalize numeric vector}
\usage{
normalization(x, method = "max_min", na_rm = TRUE, ...)
}
\arguments{
\item{x}{Input numeric vector.}

\item{method}{Method used for normalization.}

\item{na_rm}{Whether to remove \code{NA} values, and if setting \code{TRUE}, using \code{0} instead.
Default is \code{TRUE}.}

\item{...}{Parameters for other methods.}
}
\value{
Normalized numeric vector.
}
\description{
Normalize numeric vector
}
\examples{
x <- c(runif(2), NA, -runif(2))
x
normalization(x, method = "max_min")
normalization(x, method = "maximum")
normalization(x, method = "sum")
normalization(x, method = "softmax")
normalization(x, method = "z_score")
normalization(x, method = "mad")
normalization(x, method = "unit_vector")
normalization(x, method = "unit_vector", na_rm = FALSE)
}
