% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{retrieve_index}
\alias{retrieve_index}
\title{Retrieve a \code{tbl_time} index}
\usage{
retrieve_index(x, as_name = FALSE)
}
\arguments{
\item{x}{A \code{tbl_time} object.}

\item{as_name}{Logical specifying whether to return
the index as a tibble or a character of the column name.}
}
\description{
Return the index column as a tibble or as a character
}
\examples{

x <- tibble::tibble(
  date  = as.Date(c('2017-01-01', '2017-01-02')),
  value = c(1, 2)
)

x <- as_tbl_time(x, date)

retrieve_index(x)

}
