% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_guess.R, R/spec_guess_df.R,
%   R/spec_guess_object.R
\name{guess_tspec}
\alias{guess_tspec}
\alias{guess_tspec_df}
\alias{guess_tspec_object}
\title{Guess the \code{tibblify()} Specification}
\usage{
guess_tspec(
  x,
  ...,
  empty_list_unspecified = FALSE,
  simplify_list = FALSE,
  inform_unspecified = should_inform_unspecified(),
  call = rlang::current_call()
)

guess_tspec_df(
  x,
  ...,
  empty_list_unspecified = FALSE,
  simplify_list = FALSE,
  inform_unspecified = should_inform_unspecified(),
  call = rlang::current_call()
)

guess_tspec_object(
  x,
  ...,
  empty_list_unspecified = FALSE,
  simplify_list = FALSE,
  call = rlang::current_call()
)
}
\arguments{
\item{x}{A nested list.}

\item{...}{These dots are for future extensions and must be empty.}

\item{empty_list_unspecified}{Treat empty lists as unspecified?}

\item{simplify_list}{Should scalar lists be simplified to vectors?}

\item{inform_unspecified}{Inform about fields whose type could not be
determined?}

\item{call}{The execution environment of a currently running function, e.g.
\code{caller_env()}. The function will be mentioned in error messages as the
source of the error. See the \code{call} argument of \code{\link[=abort]{abort()}} for more
information.}
}
\value{
A specification object that can used in \code{tibblify()}.
}
\description{
Use \code{guess_tspec()} if you don't know the input type.
Use \code{guess_tspec_df()} if the input is a data frame or an object list.
Use \code{guess_tspec_objecte()} is the input is an object.
}
\examples{
guess_tspec(list(x = 1, y = "a"))
guess_tspec(list(list(x = 1), list(x = 2)))

guess_tspec(gh_users)
}
