% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-solutions-mplus.R
\name{compare_solutions_mplus}
\alias{compare_solutions_mplus}
\title{Explore fit statistics various models and numbers of profiles using MPlus (requires purchasing and installing MPlus to use)}
\usage{
compare_solutions_mplus(df, ..., n_profiles_min = 2,
  n_profiles_max = 10, models = list(c("equal", "zero"), c("varying",
  "zero"), c("equal", "equal"), c("varying", "varying")), starts = c(100,
  10), cluster_ID = NULL, m_iterations = 500, st_iterations = 20,
  convergence_criterion = 1e-06, remove_tmp_files = FALSE,
  save_models = FALSE, return_table = TRUE, n_processors = 1,
  return_stats_df = TRUE, include_VLMR = TRUE, include_BLRT = FALSE,
  dir_name = NULL)
}
\arguments{
\item{df}{data.frame with two or more columns with continuous variables}

\item{...}{unquoted variable names separated by commas}

\item{n_profiles_min}{lower bound of the number of profiles to explore; defaults to 2}

\item{n_profiles_max}{upper bound of the number of profiles to explore; defaults to 10}

\item{models}{which models to include as a list of vectors; for each vector, the first value represents how the variances are estimated and the second value represents how the covariances are estimated; defaults to list(c("equal", "zero"), c("varying", "zero"), c("equal", "equal"), c("varying", "varying"))}

\item{starts}{number of initial stage starts and number of final stage optimizations; defaults to c(20, 4); can be set to be more conservative to c(500, 50)}

\item{cluster_ID}{clustering variable to use as part of MPlus 'type is complex' command}

\item{m_iterations}{number of iterations for the EM algorithm; defaults to 500}

\item{st_iterations}{the number of initial stage iterations; defaults to 10; can be set more to be more conservative to 50}

\item{convergence_criterion}{convergence criterion for the Quasi-Newton algorithm for continuous outcomes; defaults to 1E-6 (.000001); can be set more conservatively to 1E-7 (.0000001)}

\item{remove_tmp_files}{whether to remove data, script, and output files; defaults to TRUE}

\item{save_models}{whether to save the models as rds files}

\item{return_table}{logical (TRUE or FALSE) for whether to return a table of the output instead of a plot; defaults to TRUE}

\item{n_processors}{= 1}

\item{return_stats_df}{whether to return a list of fit statistics for the solutions explored; defaults to TRUE}

\item{include_VLMR}{whether to include the Vu-Lo-Mendell-Rubin likelihood-ratio test; defaults to TRUE}

\item{include_BLRT}{whether to include the bootstrapped LRT; defaults to FALSE because of the time this takes to run}

\item{dir_name}{character; name for directory .out files are saved to if save_models = TRUE; defaults to the present date}
}
\value{
a list with a data.frame with the BIC values and a list with all of the model output; if save_models is the name of an rds file (i.e., "out.rds"), then the model output will be written with that filename and only the data.frame will be returned
}
\description{
Explore fit statistics various models and numbers of profiles using MPlus (requires purchasing and installing MPlus to use)
}
\details{
Explore the BIC values of a range of Mplus models in terms of a) the structure of the residual covariance matrix and b) the number of mixture components (or profiles)
}
\examples{
\dontrun{
o <- compare_solutions_mplus(iris, Sepal.Length, Sepal.Width, Petal.Length, Petal.Width,
n_profiles_max = 3)
}
}
