% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-profiles.R
\name{get_data}
\alias{get_data}
\alias{get_data.tidyLPA}
\alias{get_data.tidyProfile}
\title{Get data from objects generated by tidyLPA}
\usage{
get_data(x, ...)

\method{get_data}{tidyLPA}(x, ...)

\method{get_data}{tidyProfile}(x, ...)
}
\arguments{
\item{x}{An object generated by tidyLPA.}

\item{...}{further arguments to be passed to or from other methods. They are
ignored in this function.}
}
\value{
A tibble.
}
\description{
Get data from objects generated by tidyLPA.
}
\section{Methods (by class)}{
\itemize{
\item \code{tidyLPA}: Get data for a latent profile analysis with multiple
numbers of classes and models, of class 'tidyLPA'.

\item \code{tidyProfile}: Get data for a single latent profile analysis object,
of class 'tidyProfile'.
}}

\examples{
\dontrun{
if(interactive()){
 results <- iris \%>\%
   select(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width) \%>\%
   estimate_profiles(3)
 get_data(results)
 get_data(results[[1]])
 }
}
}
\author{
Caspar J. van Lissa
}
