% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-profiles.R
\name{plot_profiles}
\alias{plot_profiles}
\alias{plot_profiles.default}
\alias{plot_profiles.tidyLPA}
\title{Create latent profile plots}
\usage{
plot_profiles(x, variables = NULL, ci = 0.95, sd = TRUE,
  add_line = TRUE, rawdata = TRUE, bw = FALSE, alpha_range = c(0,
  0.1), ...)

\method{plot_profiles}{default}(x, variables = NULL, ci = 0.95,
  sd = TRUE, add_line = TRUE, rawdata = TRUE, bw = FALSE,
  alpha_range = c(0, 0.1), ...)

\method{plot_profiles}{tidyLPA}(x, variables = NULL, ci = 0.95,
  sd = TRUE, add_line = TRUE, rawdata = TRUE, bw = FALSE,
  alpha_range = c(0, 0.1), ...)
}
\arguments{
\item{x}{An object containing the results of a mixture model analysis.}

\item{variables}{A character vectors with the names of the variables to be
plotted (optional).}

\item{ci}{Numeric. What confidence interval should the errorbars span?
Defaults to a 95\% confidence interval. Set to NULL to remove errorbars.}

\item{sd}{Logical. Whether to display a box encompassing +/- 1SD Defaults to
TRUE.}

\item{add_line}{Logical. Whether to display a line, connecting cluster centroids
belonging to the same latent class. Defaults to TRUE. Note that the
information conveyed by such a line is limited.}

\item{rawdata}{Should raw data be plotted in the background? Setting this to
TRUE might result in long plotting times.}

\item{bw}{Logical. Should the plot be black and white (for print), or color?}

\item{alpha_range}{The minimum and maximum values of alpha (transparancy) for
the raw data. Minimum should be 0; lower maximum values of alpha can help
reduce overplotting.}

\item{...}{Arguments passed to and from other functions.}
}
\value{
An object of class 'ggplot'.
}
\description{
Creates a profile plot according to best practices, focusing on the
visualization of classification uncertainty by showing:
\enumerate{
\item Bars reflecting a confidence interval for the class centroids
\item Boxes reflecting the standard deviations within each class; a box
encompasses +/- 64\% of the observations in a normal distribution
\item Raw data, whose transparancy is weighted by the posterior class
probability, such that each datapoint is most clearly visible for the class
it is most likely to be a member of.
}
}
\examples{
# Example 1

# Example 2

\donttest{
mtcars \%>\%
  subset(select = c("wt", "qsec", "drat")) \%>\%
  poms \%>\%
  estimate_profiles(1:4) \%>\%
  plot_profiles(add_line = F)
}
}
\author{
Caspar J. van Lissa
}
\keyword{mixture}
\keyword{plot}
