% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-corplot.R
\name{plot_bivariate}
\alias{plot_bivariate}
\title{Create correlation plots for a mixture model}
\usage{
plot_bivariate(
  x,
  variables = NULL,
  sd = TRUE,
  cors = TRUE,
  rawdata = TRUE,
  bw = FALSE,
  alpha_range = c(0, 0.1),
  return_list = FALSE
)
}
\arguments{
\item{x}{tidyProfile object to plot. A tidyProfile is one element of a
tidyLPA analysis.}

\item{variables}{Which variables to plot. If NULL, plots all variables that
are present in all models.}

\item{sd}{Logical. Whether to show the estimated standard deviations as lines
emanating from the cluster centroid.}

\item{cors}{Logical. Whether to show the estimated correlation (standardized
covariance) as ellipses surrounding the cluster centroid.}

\item{rawdata}{Logical. Whether to plot raw data, weighted by posterior class
probability.}

\item{bw}{Logical. Whether to make a black and white plot (for print) or a
color plot. Defaults to FALSE, because these density plots are hard to read
in black and white.}

\item{alpha_range}{Numeric vector (0-1). Sets
the transparency of geom_density and geom_point.}

\item{return_list}{Logical. Whether to return a list of ggplot objects, or
just the final plot. Defaults to FALSE.}
}
\value{
An object of class 'ggplot'.
}
\description{
Creates a faceted plot of two-dimensional correlation plots and
unidimensional density plots for an object of class 'tidyProfile'.
}
\examples{
# Example 1
iris_sample <- iris[c(1:10, 51:60, 101:110), ] # to make example run more quickly
\dontrun{
iris_sample \%>\%
 subset(select = c("Sepal.Length", "Sepal.Width")) \%>\%
 estimate_profiles(n_profiles = 2, models = 1) \%>\%
 plot_bivariate()
}
# Example 2
\dontrun{
mtcars \%>\%
  subset(select = c("wt", "qsec", "drat")) \%>\%
  poms() \%>\%
  estimate_profiles(3) \%>\%
  plot_bivariate()
}
}
\author{
Caspar J. van Lissa
}
\keyword{correlation}
\keyword{mixture}
\keyword{plot}
