% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_micro.R
\name{tidy_micro}
\alias{tidy_micro}
\title{A function to merge multiple OTU tables and clinical data into a "tidy" format}
\usage{
tidy_micro(
  otu_tabs,
  tab_names,
  clinical,
  prev_cutoff = 0,
  ra_cutoff = 0,
  exclude_taxa = NULL,
  library_name = "Lib",
  complete_clinical = T,
  filter_summary = T
)
}
\arguments{
\item{otu_tabs}{A single table or list of metagenomic sequencing data. Tables should have a first column of OTU Names and following columns of OTU counts. Column names should be sequencing library names}

\item{tab_names}{names for otu_tabs. These will become the "Tables" column. It is also an option to simply name the OTU tables in the list supplied to otu_tabs}

\item{clinical}{Sequencing level clinical data. Must have a column with unique names for library (sequencing ID)}

\item{prev_cutoff}{A prevalence cutoff where *X* percent of libraries must have this taxa or it will be included in the "Other" category}

\item{ra_cutoff}{A relative abundance (RA) cutoff where at least one library must have a RA above the cutoff or the taxa will be included in the "Other" category}

\item{exclude_taxa}{A character vector used to specify any taxa that you would like to included in the "Other" category. Taxa specified will be included in "Other" for every OTU table provided}

\item{library_name}{The column name containing sequencing library names. Should match with column names of supplied OTU tables (after first column)}

\item{complete_clinical}{Logical; only include columns from OTU tables who's library name is in clinical data}

\item{filter_summary}{Logical; print out summaries of filtering steps}
}
\value{
A data.frame in the tidy_micro format
}
\description{
A function to take any number of OTU tables (or other sequencing data tables), calculate taxa prevalence, relative abundance, and a CLR transformation, and finally merges clinical data
}
\details{
Column names of the OTU tables must be the same for each table, and these should be the the library names inside of your clinical. Please see the \link{vignette} for a detailed description.

The CLR transformation adds (1 / sequencing depth) to each OTU count for each library before centering and log transforming in order to avoid issues with 0 counts.

The list of OTU tables are split, manipulated, and stacked into a data frame using the \code{\link[plyr]{ldply}} function from the \pkg{plyr} package. Names of OTU tables supplied will be the name of their "Table" in the final tidy_micro set
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)

## Multiple OTU tables with named list
otu_tabs <- list(Phylum = phy, Class = cla, Order = ord, Family = fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin)

## Multiple OTU tables with unnamed list
unnamed_tabs <- list(phy,cla,ord,fam)
set <- tidy_micro(otu_tabs = unnamed_tabs,
tab_names = c("Phylum", "Class", "Order", "Family"), clinical = clin)

## Single OTU table
set <- tidy_micro(otu_tabs = cla, tab_names = "Class", clinical = clin)

## Filtering out low abundance or uninteresting taxa right away
## WARNING: Only do this if you do not want to calculate alpha diversities with this micro_set

filter_set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin,
              prev_cutoff = 5, ## 5\% of libraries must have this bug, or it is filtered
              ra_cutoff = 1, ## At least 1 libraries must have RA of 1, or it is filtered
              exclude_taxa = c("Unclassified", "Bacteria") ## Unclassified taxa we don't want
              )
}
\author{
Charlie Carpenter
}
