% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose_cells.R
\name{compose_cells}
\alias{compose_cells}
\title{Compose a Cell Analysis to a tidy form}
\usage{
compose_cells(ca, post_process = TRUE, attr_sep = " :: ",
  discard_raw_cols = FALSE, print_attribute_overview = FALSE)
}
\arguments{
\item{ca}{a cell_analysis to process}

\item{post_process}{logical scalar. If disabled a list will be returned without performing post-processing. (Default \code{TRUE})}

\item{attr_sep}{a character string to separate the attributes. (Default is \code{<space>::<space>})}

\item{discard_raw_cols}{logical scalar. If enabled only main processed columns will be returned. (Default \code{FALSE})}

\item{print_attribute_overview}{print the overview of the attributes (4 distinct values from each attribute of each block)}
}
\value{
a data.frame (as tibble) in tidy form.
}
\description{
After \code{\link[=analyze_cells]{analyze_cells}} carried out, you may like to use this function in order to
stitch the cells together as per the analyzed results, to form a meaningful structural representation (like tidy format).
}
\examples{
cd <- 1:(9) \%>\%
  matrix(nrow = 3) \%>\%
  as_cell_df()
cd <- sample_based_classifier(cd, attribute_sample = "1")
cd <- cd \%>\% dplyr::filter(value != "1")
ca <- analyze_cells(cd)

compose_cells(ca)
}
