% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_ga.R
\name{segment_ga}
\alias{segment_ga}
\alias{segment_ga_shi}
\alias{segment_ga_coen}
\alias{segment_ga_random}
\title{Segment a time series using a genetic algorithm}
\usage{
segment_ga(
  x,
  model_fn = fit_meanshift_norm,
  penalty_fn = BIC,
  model_fn_args = list(),
  ...
)

segment_ga_shi(x, ...)

segment_ga_coen(x, ...)

segment_ga_random(x, ...)
}
\arguments{
\item{x}{A time series}

\item{model_fn}{A \code{character} or \code{name} coercible into a \link{fun_cpt} function.
See, for example, \code{\link[=fit_meanshift_norm]{fit_meanshift_norm()}}.}

\item{penalty_fn}{A function that evaluates the changepoint set returned by
\code{model_fn}. We provide \code{\link[=AIC]{AIC()}}, \code{\link[=BIC]{BIC()}}, \code{\link[=MBIC]{MBIC()}}, \code{\link[=MDL]{MDL()}}, and \code{\link[=BMDL]{BMDL()}}.}

\item{model_fn_args}{A \code{\link[=list]{list()}} of parameters passed to \code{model_fn}}

\item{...}{arguments passed to \code{\link[GA:ga]{GA::ga()}}}
}
\value{
A \code{tidyga} object. This is just a \code{\link[GA:ga]{GA::ga()}} object with an additional
slot for \code{data} (the original time series) and \code{model_fn_args} (captures
the \code{model_fn} and \code{penalty_fn} arguments).
}
\description{
Segmenting functions for various genetic algorithms
}
\details{
\code{\link[=segment_ga]{segment_ga()}} uses the genetic algorithm in \code{\link[GA:ga]{GA::ga()}} to "evolve" a random
set of candidate changepoint sets, using the penalized objective function
specified by \code{penalty_fn}.
By default, the normal \code{meanshift} model is fit (see \code{\link[=fit_meanshift_norm]{fit_meanshift_norm()}})
and the \link{BIC} penalty is applied.

\itemize{
\item \code{\link[=segment_ga_shi]{segment_ga_shi()}}: Shi's algorithm is the algorithm used in
\doi{10.1175/JCLI-D-21-0489.1}.
Note that in order to achieve the reported results you have to run the algorithm
for a really long time.
Pass the values \code{maxiter} = 50000 and \code{run} = 10000
to \code{\link[GA:ga]{GA::ga()}} using the dots.
}

\itemize{
\item \code{\link[=segment_ga_coen]{segment_ga_coen()}}: Coen's algorithm is the one used in
\doi{10.1007/978-3-031-47372-2_20}.
Note that the speed of the algorithm is highly sensitive to the size of the
changepoint sets under consideration, with large changepoint sets being slow.
Consider setting the \code{population} argument to \code{\link[GA:ga]{GA::ga()}} to improve
performance. Coen's algorithm uses the \code{\link[=build_gabin_population]{build_gabin_population()}} function
for this purpose by default.
}

\itemize{
\item \code{\link[=segment_ga_random]{segment_ga_random()}}: Randomly select candidate changepoint sets. This
is implemented as a genetic algorithm with only one generation (i.e.,
\code{maxiter = 1}). Note
that this function uses \code{\link[=log_gabin_population]{log_gabin_population()}} by default.
}
}
\examples{
# Segment a time series using a genetic algorithm
res <- segment_ga(CET, maxiter = 5)
summary(res)
str(res)
plot(res)

\donttest{
# Segment a time series using Shi's algorithm
x <- segment(CET, method = "ga-shi", maxiter = 5)
str(x)

# Segment a time series using Coen's algorithm
y <- segment(CET, method = "ga-coen", maxiter = 5)
changepoints(y)

# Segment a time series using Coen's algorithm and an arbitrary threshold
z <- segment(CET, method = "ga-coen", maxiter = 5, 
             model_fn_args = list(threshold = 2))
changepoints(z)
}
\dontrun{
# This will take a really long time!
x <- segment(CET, method = "ga-shi", maxiter = 500, run = 100)
changepoints(x)

# This will also take a really long time!
y <- segment(CET, method = "ga", model_fn = fit_lmshift, penalty_fn = BIC, 
  popSize = 200, maxiter = 5000, run = 1000, 
  model_fn_args = list(trends = TRUE), 
  population = build_gabin_population(CET)
)
}

\dontrun{
x <- segment(method = "ga-coen", maxiter = 50)
}

x <- segment(CET, method = "random")
}
\references{
Shi, et al. (2022, \doi{10.1175/JCLI-D-21-0489.1})

Taimal, et al. (2023, \doi{10.1007/978-3-031-47372-2_20})
}
\seealso{
\code{\link[=build_gabin_population]{build_gabin_population()}}

\code{\link[=log_gabin_population]{log_gabin_population()}}
}
