% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_chart_markers.R
\name{line_chart_markers_reference}
\alias{line_chart_markers_reference}
\title{Generates line plot with markers on every value with index on a given value.}
\usage{
line_chart_markers_reference(
  data,
  x,
  series,
  series_labels,
  ref_val,
  ref_label = ref_val,
  interval = "months",
  styles = NULL
)
}
\arguments{
\item{data}{data frame containing data to be plotted}

\item{x}{vector containing time intervals of the values}

\item{series}{vector containing names of columns in data with values to plot}

\item{series_labels}{vector containing names of series to be shown on the plot}

\item{ref_val}{numeric value of the index}

\item{ref_label}{string defining a text that should be displayed in the referencing line. Set by default to index_val.}

\item{interval}{intervals on x axis. The width of the bars depends on this parameter}

\item{styles}{optional data frame with style names. Styles of the markers will be plotted accordingly.}
}
\value{
SVG string containing chart
}
\description{
Generates line plot with markers on every value with index on a given value.
}
\examples{

#preparing a data frame
data <- data.frame(
time = c("Jan", "Feb", "Mar", "Apr", "May", "Jun"),
PL = (c(51, 42, 50, 58, 78, 79) - 30),
AC = (c(62, 70, 67, 77, 63, 62) - 30)
)
#preparing the styles data frame
styles <- data.frame(
 PL = c("plan", "plan", "plan", "plan", "plan", "plan"),
 AC = c("actual", "actual", "actual", "forecast", "forecast", "forecast")
)

#generating svg string
line_chart_ref <- line_chart_markers_reference(
  data = data,
  x = data$time,
  series = c("PL", "AC"),
  series_labels = c("PL", "AC"),
  ref_val = 42,
  ref_label = "index",
  styles=styles)

#show the plot
line_chart_ref \%>\% SVGrenderer()

}
