% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_characterization.R
\name{extract_centroids}
\alias{extract_centroids}
\title{Extract clusters from model}
\usage{
extract_centroids(object, ...)
}
\arguments{
\item{object}{An cluster_spec object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A \code{tibble::tibble()} with 1 row for each centroid and their position.
}
\description{
Extract clusters from model
}
\examples{
set.seed(1234)
kmeans_spec <- k_means(num_clusters = 5) \%>\%
  set_engine("stats")

kmeans_fit <- fit(kmeans_spec, ~., mtcars)

kmeans_fit \%>\%
  extract_centroids()
}
