% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_methods.R
\name{predict.tidycrr}
\alias{predict.tidycrr}
\title{Estimate subdistribution functions for crr objects}
\usage{
\method{predict}{tidycrr}(object, times = NULL, probs = NULL, newdata = NULL, ...)
}
\arguments{
\item{object}{a tidycrr object}

\item{times}{Numeric vector of times to obtain risk estimates at}

\item{probs}{Numeric vector of quantiles to obtain estimates at}

\item{newdata}{A \code{base::data.frame()} or \code{tibble::tibble()} containing all
the original predictors used to create x. Defaults to \code{NULL}.}

\item{...}{not used}
}
\value{
named list of prediction estimates
}
\description{
Estimate subdistribution functions for crr objects
}
\examples{
crr(Surv(ttdeath, death_cr) ~ age, trial) \%>\%
  predict(times = 12, newdata = trial[1:10, ])
}
\seealso{
Other crr() functions: 
\code{\link{broom_methods_crr}},
\code{\link{crr}()}
}
\concept{crr() functions}
