% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{describe_cat}
\alias{describe_cat}
\title{Describe categorical variables}
\usage{
describe_cat(data, ...)
}
\arguments{
\item{data}{a \link[tibble:tibble-package]{tibble} or a \link{tdcmm} model}

\item{...}{Variables to describe (column names). Leave empty to describe all
categorical variables in data.}
}
\value{
a \link{tdcmm} model
}
\description{
Describe categorical variables by N, number of unique values, and mode.
Note that in case of multiple modes, the first mode by order of values
is chosen.
}
\details{
If no variables are specified, all categorical (character or factor)
variables are described.
\itemize{
\item N: number of valid cases (i.e., all but missing)
\item Missing: number of NA cases
\item Unique: number of unique categories in a given variable, without Missing
\item Mode: mode average (if multiple modes exist, first mode by order of values is returned)
\item Mode_N: number of cases reflecting the Mode
}
}
\examples{
WoJ \%>\% describe_cat(reach, employment, temp_contract)
fbposts \%>\% describe_cat(type)

}
\seealso{
Other descriptives: 
\code{\link{describe}()},
\code{\link{tab_percentiles}()}
}
\concept{descriptives}
