% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_inputs}
\alias{parse_inputs}
\title{Parse the inputs of the CWL workflow into a data frame}
\usage{
parse_inputs(x, simplify = TRUE)
}
\arguments{
\item{x}{CWL object}

\item{simplify}{Simplify the list as a data frame?}
}
\value{
List or data frame of inputs
}
\description{
Parse the inputs of the CWL workflow into a data frame
}
\examples{
system.file("cwl/sbg/workflow/rnaseq-salmon.json", package = "tidycwl") \%>\%
  read_cwl_json() \%>\%
  parse_inputs() \%>\%
  names()

system.file("cwl/sbg/workflow/rnaseq-salmon.cwl", package = "tidycwl") \%>\%
  read_cwl_yaml() \%>\%
  parse_inputs() \%>\%
  names()
}
