% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_sub_dann.R
\name{tidy_sub_dann}
\alias{tidy_sub_dann}
\title{Discriminant Adaptive Nearest Neighbor With Subspace Reduction}
\usage{
tidy_sub_dann(
  mode = "classification",
  neighbors = NULL,
  neighborhood = NULL,
  epsilon = NULL,
  weighted = NULL,
  sphere = NULL,
  num_comp = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "classification".}

\item{neighbors}{The number of data points used for final classification.}

\item{neighborhood}{The number of data points used to calculate between and
within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity
matrix.}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{sphere}{One of "mcd", "mve", "classical", or "none" See \code{\link[fpc:ncoord]{fpc::ncoord()}}
for details.}

\item{num_comp}{Dimension of subspace used by dann. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for
details.}
}
\value{
An S3 class of type tidy_sub_dann.
}
\description{
Discriminant Adaptive Nearest Neighbor With Subspace Reduction
}
\details{
dann's performance suffers when noise variables are included in the model.
Simulations show sub_dann will generally be more performant in this scenario.
}
\examples{

library(rsample)
library(parsnip)
library(tidydann)

data("two_class_dat", package = "modeldata")
set.seed(1)
example_split <- initial_split(two_class_dat, prop = 0.99)
example_train <- training(example_split)
example_test <- testing(example_split)

model <- tidy_sub_dann(neighbors = 2) |>
  set_engine("sub_dann") |>
  fit(formula = Class ~ A + B, data = example_train)

model |>
  predict(new_data = example_test)

}
