% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyformula.R
\name{tidyformula}
\alias{tidyformula}
\title{Build a formula using \code{tidyselect}-style selection helpers}
\usage{
tidyformula(
  formula,
  data,
  select_helpers = .select_helpers,
  nodistribute = c("+", "-", "*", "^"),
  env = rlang::caller_env()
)
}
\arguments{
\item{formula}{An object of class \code{\link{formula}}. Can contain selection helpers
to be expanded.}

\item{data}{A data frame whose column names should be used for selection}

\item{select_helpers}{A character vector. The names of selection helpers to
be matched and substituted.}

\item{nodistribute}{A character vector. Functions with these names are not
distributed over selection helpers.}

\item{env}{The environment to associate with the result.}
}
\value{
An object of class \code{\link{formula}}, which is a translation of the argument
\code{formula} in which the selection helpers are replaced with the corresponding
variables of \code{data}.
}
\description{
\code{tidyformula()} translates formulas containing \code{tidyselect}-style
\link[tidyselect:language]{selection helpers}, expanding these helpers by evaluating
\code{\link[dplyr:select]{dplyr::select()}} with the relevant selection helper and a supplied data frame.

When the selection helper appears as the first argument of a function, that
function is distributed across the sum of the selected variables.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{df <- data.frame(
  x1 = rnorm(5),
  x2 = rnorm(5),
  x3 = rnorm(5),
  y  = rnorm(5)
)

tidyformula(y ~ num_range("x", 1:2) + z, data = df)
#> y ~ x1 + x2 + z
#> <environment: 0x000001e0d7d53910>

tidyformula(y ~ poly(starts_with("x"), 3), data = df)
#> y ~ poly(x1, 3) + poly(x2, 3) + poly(x3, 3)
#> <environment: 0x000001e0d7d53910>

tidyformula( ~ everything() * contains("x"), data = df)
#> ~(x1 + x2 + x3 + y) * (x1 + x2 + x3)
#> <environment: 0x000001e0d7d53910>
}\if{html}{\out{</div>}}

Interaction operators are typically not distributed, but this behaviour can be changed.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tidyformula(y ~ starts_with("x")^2, data = df)
#> y ~ (x1 + x2 + x3)^2
#> <environment: 0x000001e0d7d53910>

tidyformula(y ~ starts_with("x")^2, data = df, nodistribute = c("+", "-"))
#> y ~ x1^2 + x2^2 + x3^2
#> <environment: 0x000001e0d7d53910>
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[dplyr:select]{dplyr::select()}}, \code{\link[tidyselect:language]{tidyselect::language}} for
documentation of selection helpers.
}
