% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_delete_na.R
\name{drop_na}
\alias{drop_na}
\alias{delete_na}
\title{Drop or delete data by rows or columns}
\usage{
drop_na(.data, ...)

delete_na(.data, MARGIN, n)
}
\arguments{
\item{.data}{A data.table}

\item{...}{Colunms to be dropped or deleted.}

\item{MARGIN}{1 or 2. 1 for deleting rows, 2 for deleting columns.}

\item{n}{If number (proportion) of NAs is larger than or equal to "n",
the columns/rows would be deleted. When smaller than 1, use as proportion.
When larger or equal to 1, use as number.}
}
\value{
A data.table
}
\description{
\code{drop_na} drops entries by specified columns.
\code{delete_na} deletes rows or columns with too many NAs.
}
\examples{
x = data.table(x = c(1, 2, NA, 3), y = c(NA, NA, 4, 5),z = rep(NA,4))
x
x \%>\% delete_na(2,0.75)

x = data.table(x = c(1, 2, NA, 3), y = c(NA, NA, 4, 5),z = rep(NA,4))
x \%>\% delete_na(2,0.5)

x = data.table(x = c(1, 2, NA, 3), y = c(NA, NA, 4, 5),z = rep(NA,4))
x \%>\% delete_na(2,0.24)

x = data.table(x = c(1, 2, NA, 3), y = c(NA, NA, 4, 5),z = rep(NA,4))
x \%>\% delete_na(2,2)

x = data.table(x = c(1, 2, NA, 3), y = c(NA, NA, 4, 5),z = rep(NA,4))
x \%>\% delete_na(1,0.6)
x = data.table(x = c(1, 2, NA, 3), y = c(NA, NA, 4, 5),z = rep(NA,4))
x \%>\% delete_na(1,2)


}
