% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode_combine.R
\name{geocode_combine}
\alias{geocode_combine}
\title{Combine multiple geocoding queries}
\usage{
geocode_combine(
  .tbl,
  queries,
  global_params = list(),
  return_list = FALSE,
  cascade = TRUE,
  query_names = NULL,
  lat = "lat",
  long = "long"
)
}
\arguments{
\item{.tbl}{dataframe containing addresses}

\item{queries}{a list of queries, each provided as a list of parameters. The queries are
executed by the \link{geocode} function in the order provided.
(ex. \code{list(list(method = 'osm'), list(method = 'census'), ...)})}

\item{global_params}{a list of parameters to be used for all queries
(ex. \code{list(address = 'address', full_results = TRUE)})}

\item{return_list}{if TRUE then results from each service will be returned as separate
dataframes. If FALSE (default) then all results will be combined into a single dataframe.}

\item{cascade}{if TRUE (default) then only addresses that are not found by a geocoding
service will be attempted by subsequent queries. If FALSE then all queries will
attempt to geocode all addresses.}

\item{query_names}{optional vector with one label for each query provided
(ex. \code{c('geocodio batch', 'geocodio single')}).}

\item{lat}{latitude column name. Can be quoted or unquoted (ie. lat or 'lat').}

\item{long}{longitude column name. Can be quoted or unquoted (ie. long or 'long').}
}
\value{
tibble (dataframe)
}
\description{
Executes multiple geocoding queries on a dataframe input and combines
the results. To use a character vector input instead, see the \link{geo_combine} function.
Queries are executed by the \link{geocode} function. See example usage
in \code{vignette("tidygeocoder")}.

Query results are by default labelled to show which query produced each result. Labels are either
placed in a \code{query} column (if \code{return_list = FALSE}) or used as the names of the returned list
(if \code{return_list = TRUE}). By default the \code{method} parameter value of each query is used as a query label.
If the same \code{method} is used in multiple queries then a number is added according
to the order of the queries (ie. \code{osm1}, \code{osm2}, ...). To provide your own custom query labels
use the \code{query_names} parameter.
}
\examples{
\donttest{

library(dplyr, warn.conflicts = FALSE)

sample_addresses \%>\%
  geocode_combine(
    queries = list(list(method = 'census'), list(method = 'osm')),
    global_params = list(address = 'addr'), cascade = TRUE)

more_addresses <- tibble::tribble(
     ~street_address, ~city, ~state,        ~zip_cd,
     "624 W DAVIS ST #1D",   "BURLINGTON", "NC", 27215,
     "201 E CENTER ST #268", "MEBANE",     "NC", 27302,
     "100 Wall Street",      "New York",   "NY", 10005,
     "Bucharest",            NA,           NA,   NA
     )
 
 more_addresses \%>\%        
   geocode_combine( 
     queries = list(
         list(method = 'census', mode = 'batch'),
         list(method = 'census', mode = 'single'),
         list(method = 'osm')
      ),
     global_params = list(street = 'street_address', 
       city = 'city', state = 'state', postalcode = 'zip_cd'),
     query_names = c('census batch', 'census single', 'osm')
   )
   
 more_addresses \%>\%
   geocode_combine( 
     queries = list(
         list(method = 'census', mode = 'batch', street = 'street_address', 
       city = 'city', state = 'state', postalcode = 'zip_cd'),
         list(method = 'arcgis', address = 'street_address')
      ),
     cascade = FALSE,
     return_list = TRUE
   )
}
}
\seealso{
\link{geo_combine} \link{geo} \link{geocode}
}
