% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_cfg.R
\name{QoI_cfg}
\alias{QoI_cfg}
\title{Configuration of Quantities of Interest}
\description{
\code{QoI_cfg} is a configuration class for the Quantities of Interest to be
generated by the HTE analysis.
}
\examples{
mcate_cfg <- MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))
pcate_cfg <- PCATE_cfg$new(
   cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)),
   model_covariates = c("x1", "x2", "x3"),
   num_mc_samples = list(x1 = 100)
)
vimp_cfg <- VIMP_cfg$new()
diag_cfg <- Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE"),
   ps = c("SL_risk", "SL_coefs", "AUC")
)
QoI_cfg$new(
    mcate = mcate_cfg,
    pcate = pcate_cfg,
    vimp = vimp_cfg,
    diag = diag_cfg
)

## ------------------------------------------------
## Method `QoI_cfg$new`
## ------------------------------------------------

mcate_cfg <- MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))
pcate_cfg <- PCATE_cfg$new(
   cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)),
   model_covariates = c("x1", "x2", "x3"),
   num_mc_samples = list(x1 = 100)
)
vimp_cfg <- VIMP_cfg$new()
diag_cfg <- Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE"),
   ps = c("SL_risk", "SL_coefs", "AUC")
)
QoI_cfg$new(
    mcate = mcate_cfg,
    pcate = pcate_cfg,
    vimp = vimp_cfg,
    diag = diag_cfg
)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{mcate}}{A configuration object of type \code{MCATE_cfg} of
marginal effects to calculate.}

\item{\code{pcate}}{A configuration object of type \code{PCATE_cfg} of
partial effects to calculate.}

\item{\code{vimp}}{A configuration object of type \code{VIMP_cfg} of
variable importance to calculate.}

\item{\code{diag}}{A configuration object of type \code{Diagnostics_cfg} of
model diagnostics to calculate.}

\item{\code{ate}}{Logical flag indicating whether an estimate of the
ATE should be returned.}

\item{\code{predictions}}{Logical flag indicating whether estimates of
the CATE for every unit should be returned.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-QoI_cfg-new}{\code{QoI_cfg$new()}}
\item \href{#method-QoI_cfg-clone}{\code{QoI_cfg$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QoI_cfg-new"></a>}}
\if{latex}{\out{\hypertarget{method-QoI_cfg-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{QoI_cfg} object with specified Quantities of Interest
to estimate.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QoI_cfg$new(
  mcate = NULL,
  pcate = NULL,
  vimp = NULL,
  diag = NULL,
  ate = TRUE,
  predictions = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mcate}}{A configuration object of type \code{MCATE_cfg} of marginal
effects to calculate.}

\item{\code{pcate}}{A configuration object of type \code{PCATE_cfg} of partial
effects to calculate.}

\item{\code{vimp}}{A configuration object of type \code{VIMP_cfg} of variable
importance to calculate.}

\item{\code{diag}}{A configuration object of type \code{Diagnostics_cfg} of
model diagnostics to calculate.}

\item{\code{ate}}{A logical flag for whether to calculate the Average
Treatment Effect (ATE) or not.}

\item{\code{predictions}}{A logical flag for whether to return predictions
of the CATE for every unit or not.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Diagnostics_cfg} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{mcate_cfg <- MCATE_cfg$new(cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)))
pcate_cfg <- PCATE_cfg$new(
   cfgs = list(x1 = KernelSmooth_cfg$new(neval = 100)),
   model_covariates = c("x1", "x2", "x3"),
   num_mc_samples = list(x1 = 100)
)
vimp_cfg <- VIMP_cfg$new()
diag_cfg <- Diagnostics_cfg$new(
   outcome = c("SL_risk", "SL_coefs", "MSE"),
   ps = c("SL_risk", "SL_coefs", "AUC")
)
QoI_cfg$new(
    mcate = mcate_cfg,
    pcate = pcate_cfg,
    vimp = vimp_cfg,
    diag = diag_cfg
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-QoI_cfg-clone"></a>}}
\if{latex}{\out{\hypertarget{method-QoI_cfg-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QoI_cfg$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
