% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_api.R
\name{produce_plugin_estimates}
\alias{produce_plugin_estimates}
\title{Estimate models of nuisance functions}
\usage{
produce_plugin_estimates(data, outcome, treatment, ..., .weights = NULL)
}
\arguments{
\item{data}{dataframe (already prepared with \code{attach_config} and \code{make_splits})}

\item{outcome}{Unquoted name of the outcome variable.}

\item{treatment}{Unquoted name of the treatment variable.}

\item{...}{Unquoted names of covariates to include in the models of the nuisance functions.}

\item{.weights}{Unquoted name of weights column. If NULL, all analysis will assume weights
are all equal to one and sample-based quantities will be returned.}
}
\description{
This takes a dataset with an identified outcome and treatment column along
with any number of covariates and appends three columns to the dataset corresponding
to an estimate of the conditional expectation of treatment (\code{.pi_hat}), along with the
conditional expectation of the control and treatment potential outcome surfaces
(\code{.mu0_hat} and \code{.mu1_hat} respectively).
}
\details{
To see an example analysis, read \code{vignette("experimental_analysis")} in the context
of an experiment, \code{vignette("experimental_analysis")} for an observational study, or
\code{vignette("methodological_details")} for a deeper dive under the hood.
}
\examples{
library("dplyr")
if(require("palmerpenguins")) {
data(package = 'palmerpenguins')
penguins$unitid = seq_len(nrow(penguins))
penguins$propensity = rep(0.5, nrow(penguins))
penguins$treatment = rbinom(nrow(penguins), 1, penguins$propensity)
cfg <- basic_config() \%>\% 
add_known_propensity_score("propensity") \%>\%
add_outcome_model("SL.glm.interaction") \%>\%
remove_vimp()
attach_config(penguins, cfg) \%>\%
make_splits(unitid, .num_splits = 4) \%>\%
produce_plugin_estimates(outcome = body_mass_g, treatment = treatment, species, sex) \%>\%
construct_pseudo_outcomes(body_mass_g, treatment) \%>\%
estimate_QoI(species, sex)
}
}
\seealso{
\code{\link[=attach_config]{attach_config()}}, \code{\link[=make_splits]{make_splits()}}, \code{\link[=construct_pseudo_outcomes]{construct_pseudo_outcomes()}}, \code{\link[=estimate_QoI]{estimate_QoI()}}
}
